<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Original Author: marcan <marcan@notrevie.ca>                              //
// Modified for TinyContent by: Tobias Liegl (AKA CHAPI)                     //
// Site: http://www.chapi.de                                                 //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //
include_once "admin_header.php";

xoops_cp_header();

$module_handler = &xoops_gethandler('module');
$versioninfo = &$module_handler->get($xoopsModule->getVar('mid'));

tc_adminMenu(-1, _AM_TC_ABOUT . " " . $versioninfo->getInfo('name'));

// Left headings...
echo "<img src='" . XOOPS_URL . "/modules/".$xoopsModule->getVar('dirname')."/" . $versioninfo->getInfo('image') . "' alt='' hspace='0' vspace='0' align='left' style='margin-right: 10px;'/></a>";
echo "<div style='margin-top: 10px; color: #33538e; margin-bottom: 4px; font-size: 18px; line-height: 18px; font-weight: bold; display: block;'>" . $versioninfo->getInfo('name') . " version " . $versioninfo->getInfo('version') . "</div>";
if ($versioninfo->getInfo('author_realname') != '') {
    $author_name = $versioninfo->getInfo('author') . " (" . $versioninfo->getInfo('author_realname') . ")";
} else {
    $author_name = $versioninfo->getInfo('author');
} 

echo "<div style = 'line-height: 16px; font-weight: bold; display: block;'>" . _AM_TC_BY . " " . $author_name;
echo "</div>";
echo "<div style = 'line-height: 16px; display: block;'>" . $versioninfo->getInfo('license') . "</div>\n";

// Author Information
echo "<br /><table width='100%' cellspacing=1 cellpadding=3 border=0 class = outer>";
echo "<tr>";
echo "<td colspan='2' class='bg3' align='left'><b>" . _MI_TC_AUTHOR_INFO . "</b></td>";
echo "</tr>";

If ($versioninfo->getInfo('$author_name') != '') {
    echo "<tr>";
    echo "<td class='head' width = '150px' align='left'>" . _MI_TC_AUTHOR_NAME . "</td>";
    echo "<td class='even' align='left'>" . $author_name . "</td>";
    echo "</tr>";
} 
If ($versioninfo->getInfo('author_website_url') != '') {
    echo "<tr>";
    echo "<td class='head' width = '150px' align='left'>" . _MI_TC_AUTHOR_WEBSITE . "</td>";
    echo "<td class='even' align='left'><a href='" . $versioninfo->getInfo('author_website_url') . "' target='blank'>" . $versioninfo->getInfo('author_website_name') . "</a></td>";
    echo "</tr>";
} 
If ($versioninfo->getInfo('author_email') != '') {
    echo "<tr>";
    echo "<td class='head' width = '150px' align='left'>" . _MI_TC_AUTHOR_EMAIL . "</td>";
    echo "<td class='even' align='left'><a href='mailto:" . $versioninfo->getInfo('author_email') . "'>" . $versioninfo->getInfo('author_email') . "</a></td>";
    echo "</tr>";
} 
If ($versioninfo->getInfo('credits') != '') {
    echo "<tr>";
    echo "<td class='head' width = '150px' align='left'>" . _MI_TC_AUTHOR_CREDITS . "</td>";
    echo "<td class='even' align='left'>" . $versioninfo->getInfo('credits') . "</td>";
    echo "</tr>";
} 

echo "</table>";
echo "<br />\n";
// Module Development information
echo "<table width='100%' cellspacing=1 cellpadding=3 border=0 class = outer>";
echo "<tr>";
echo "<td colspan='2' class='bg3' align='left'><b>" . _MI_TC_MODULE_INFO . "</b></td>";
echo "</tr>";

If ($versioninfo->getInfo('status') != '') {
    echo "<tr>";
    echo "<td class='head' width = '200' align='left'>" . _MI_TC_MODULE_STATUS . "</td>";
    echo "<td class='even' align='left'>" . $versioninfo->getInfo('status') . "</td>";
    echo "</tr>";
} 

If ($versioninfo->getInfo('demo_site_url') != '') {
    echo "<tr>";
    echo "<td class='head' align='left'>" . _MI_TC_MODULE_DEMO . "</td>";
    echo "<td class='even' align='left'><a href='" . $versioninfo->getInfo('demo_site_url') . "' target='blank'>" . $versioninfo->getInfo('demo_site_name') . "</a></td>";
    echo "</tr>";
} 

If ($versioninfo->getInfo('support_site_url') != '') {
    echo "<tr>";
    echo "<td class='head' align='left'>" . _MI_TC_MODULE_SUPPORT . "</td>";
    echo "<td class='even' align='left'><a href='" . $versioninfo->getInfo('support_site_url') . "' target='blank'>" . $versioninfo->getInfo('support_site_name') . "</a></td>";
    echo "</tr>";
} 

If ($versioninfo->getInfo('submit_bug') != '') {
    echo "<tr>";
    echo "<td class='head' align='left'>" . _MI_TC_MODULE_BUG . "</td>";
    echo "<td class='even' align='left'><a href='" . $versioninfo->getInfo('submit_bug') . "' target='blank'>" . "Submit a Bug in SmartFAQ Bug Tracker" . "</a></td>";
    echo "</tr>";
} 
If ($versioninfo->getInfo('submit_feature') != '') {
    echo "<tr>";
    echo "<td class='head' align='left'>" . _MI_TC_MODULE_FEATURE . "</td>";
    echo "<td class='even' align='left'><a href='" . $versioninfo->getInfo('submit_feature') . "' target='blank'>" . "Request a feature in the SmartFAQ Feature Tracker" . "</a></td>";
    echo "</tr>";
} 

echo "</table>";
// Warning
If ($versioninfo->getInfo('warning') != '') {
    echo "<br />\n";
    echo "<table width='100%' cellspacing=1 cellpadding=3 border=0 class = outer>";
    echo "<tr>";
    echo "<td class='bg3' align='left'><b>" . _MI_TC_MODULE_DISCLAIMER . "</b></td>";
    echo "</tr>";

    echo "<tr>";
    echo "<td class='even' align='left'>" . $versioninfo->getInfo('warning') . "</td>";
    echo "</tr>";

    echo "</table>";
} 
// Author's note
If ($versioninfo->getInfo('author_word') != '') {
    echo "<br />\n";
    echo "<table width='100%' cellspacing=1 cellpadding=3 border=0 class = outer>";
    echo "<tr>";
    echo "<td class='bg3' align='left'><b>" . _MI_TC_AUTHOR_WORD . "</b></td>";
    echo "</tr>";

    echo "<tr>";
    echo "<td class='even' align='left'>" . $versioninfo->getInfo('author_word') . "</td>";
    echo "</tr>";

    echo "</table>";
} 

echo "<br />";
xoops_cp_footer();
?>