<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
// Author: Tobias Liegl (AKA CHAPI)                                          //
// Site: http://www.chapi.de                                                 //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //

include "../../mainfile.php";

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$contentpage = isset($_GET['page']) ? intval($_GET['page']) : 0;

include_once "class/content.class.php";
$content = new Content;

if (($xoopsModuleConfig['tc_listing'] == '1') && ($id == 0)) {

	// this page uses smarty template
	// this must be set before including main header.php
	$xoopsOption['template_main'] = 'tc_listing.html';
	include_once XOOPS_ROOT_PATH.'/header.php';

	$result = $content->get_all_contents();
	$xoopsTpl->assign('contents', $result);

	$xoopsTpl->assign('pagetitle', $xoopsModule->getVar("name"));

} else {

	if ($id != 0) {
		$result = $content->get_content($id);
	} else {
		$storyid = $content->get_homepage();
		header("Location: index.php?id=$storyid");
		exit;
	}
	
	if ($result["link"] == 1) {
		// include external content
		
		$page = XOOPS_ROOT_PATH."/modules/".$xoopsModule->getVar('dirname')."/content/".$result["address"];
		if (file_exists($page)){
			// this page uses smarty template
			// this must be set before including main header.php
			$xoopsOption['template_main'] = 'tc_index.html';
			include_once XOOPS_ROOT_PATH.'/header.php';		
			
			ob_start();
			include($page);
			$content = ob_get_contents();
			ob_end_clean();
			
			$xoopsTpl->assign('title', $result["title"]);
			$xoopsTpl->assign('content', $content);
			$xoopsTpl->assign('nocomments', $result["nocomments"]);
			$xoopsTpl->assign('mail_link', 'mailto:?subject='.sprintf(_TC_INTARTICLE,$xoopsConfig['sitename']).'&amp;body='.sprintf(_TC_INTARTFOUND, $xoopsConfig['sitename']).':  '.XOOPS_URL.'/modules/'.$xoopsModule->getVar('dirname').'/index.php?id='.$id);
			$xoopsTpl->assign('lang_printerpage', _TC_PRINTERFRIENDLY);
			$xoopsTpl->assign('lang_sendstory', _TC_SENDSTORY);
			$xoopsTpl->assign('id', $id);
			$xoopsTpl->assign('link', $result["link"]);
		} else {
			redirect_header("index.php",1,_TC_FILENOTFOUND);
		}
	} else {
		// tiny content
		
		// this page uses smarty template
		// this must be set before including main header.php
		$xoopsOption['template_main'] = 'tc_index.html';
		include_once XOOPS_ROOT_PATH.'/header.php';
		
		$html   = $result["nohtml"] == 1 ? 0 : 1;
		$smiley = $result["nosmiley"] == 1 ? 0 : 1;
		$breaks = $result["nobreaks"] == 1 ? 0 : 1;
		
		$myts =& MyTextSanitizer::getInstance();
		$text = $myts->displayTarea($myts->stripSlashesGPC($result["text"]), $html, $smiley, 1, 1, $breaks);
		
		// Code Snippet for [pagebreak] functionality
		$content = explode("[pagebreak]", $text);
		$content_pages = count($content);
			
		if ($content_pages > 1) {
			include_once XOOPS_ROOT_PATH.'/class/pagenav.php';
			$pagenav = new XoopsPageNav($content_pages, 1, $contentpage, 'page', 'id='.$id);
			$xoopsTpl->assign('pagenav', $pagenav->renderNav());
			$text = $content[$contentpage];
		}
		
		$xoopsTpl->assign('title', $result["title"]);
		$xoopsTpl->assign('content', $text);
		$xoopsTpl->assign('nocomments', $result["nocomments"]);
		$xoopsTpl->assign('mail_link', 'mailto:?subject='.sprintf(_TC_INTARTICLE,$xoopsConfig['sitename']).'&amp;body='.sprintf(_TC_INTARTFOUND, $xoopsConfig['sitename']).':  '.XOOPS_URL.'/modules/'.$xoopsModule->getVar('dirname').'/index.php?id='.$id);
		$xoopsTpl->assign('lang_printerpage', _TC_PRINTERFRIENDLY);
		$xoopsTpl->assign('lang_sendstory', _TC_SENDSTORY);
		$xoopsTpl->assign('id', $id);
		$xoopsTpl->assign('link', $result["link"]);
	}
}

// Moduladmin or not?!
if (is_object($xoopsUser)) {
    $xoopsTpl->assign('isAdmin', $xoopsUser->isAdmin());
}

include XOOPS_ROOT_PATH.'/include/comment_view.php';
include_once XOOPS_ROOT_PATH.'/footer.php';
?>