<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
// Author: Tobias Liegl (AKA CHAPI)                                          //
// Site: http://www.chapi.de                                                 //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //

$modversion['name']		    = _MI_TINYCONTENT_NAME;
$modversion['version']		= 1.61;
$modversion['author']       = 'Tobias Liegl (AKA CHAPI)';
$modversion['description']	= _MI_TINYCONTENT_DESC;
$modversion['credits']		= "The XOOPS Project";
$modversion['license']		= "GPL see LICENSE";
$modversion['help']		    = "";
$modversion['official']		= 0;
$modversion['image']		= "images/logo.png";
$modversion['dirname']		= "tinycontent";

// Added for the About page in admin section
//$modversion['author_realname'] = "";
$modversion['author_website_url'] = "http://www.chapi.de";
$modversion['author_website_name'] = "chapi.de";
$modversion['author_email'] = "info@chapi.de";
$modversion['status'] = "Beta testing";

$modversion['warning'] = "This module comes as is, without any guarantees what so ever. 
This module is BETA, meaning it is still under active development. This release is meant for
<b>testing purposes only</b> and we <b>strongly</b> recommend that you do not use it on a live 
website or in a production environment.";

//$modversion['demo_site_url'] = "";
//$modversion['demo_site_name'] = "";
$modversion['support_site_url'] = "http://dev.xoops.org/modules/xfmod/project/?tinycontent";
$modversion['support_site_name'] = "TinyContent on the Developers Forge";
//$modversion['submit_bug'] = "http://dev.xoops.org/modules/xfmod/tracker/?func=add&group_id=1026&atid=205";
//$modversion['submit_feature'] = "http://dev.xoops.org/modules/xfmod/tracker/?func=add&group_id=1026&atid=208";

$modversion['author_word'] = "Here a few words about <b>TinyContent</b> ...";

// All tables should not have any prefix!
$modversion['sqlfile']['mysql'] = "sql/mysql.sql";

// Tables created by sql file (without prefix!)
$modversion['tables'][0]	= "tinycontent";

// Admin things
$modversion['hasAdmin']		= 1;
$modversion['adminindex']	= "admin/index.php";
$modversion['adminmenu']	= "admin/menu.php";

// Search
$modversion['hasSearch'] = 1;
$modversion['search']['file'] = "include/search.inc.php";
$modversion['search']['func'] = "tinycontent_search";

// Menu
$modversion['hasMain'] = 1;
global $xoopsDB;

// Submenu Items
// Only do this query when module is active
// First you have to get the dirname of the module
$mod = $GLOBALS['xoopsModule'];
$dirname = (isset($mod) ? $mod->getVar('dirname') :'system');

if ($dirname == $modversion['dirname']) {
	$result = $xoopsDB->query("SELECT storyid, title, blockid, homepage, submenu FROM ".$xoopsDB->prefix($modversion['tables'][0])." WHERE homepage='0' AND submenu='1' ORDER BY blockid");
	$i = 1;
	
	while (list($storyid, $title) = $xoopsDB->fetchRow($result))
	{
		$modversion['sub'][$i]['name'] = $title;
		$modversion['sub'][$i]['url'] = "index.php?id=".$storyid."";
		$i++;
	} 
}

// Smarty
$modversion['use_smarty'] = 1;

// Templates
$modversion['templates'][1]['file'] = 'tc_index.html';
$modversion['templates'][1]['description'] = "Page Layout";
$modversion['templates'][2]['file'] = 'tc_listing.html';
$modversion['templates'][2]['description'] = "Content Listing";

// Blocks
$modversion['blocks'][1]['file'] = "tc_navigation.php";
$modversion['blocks'][1]['name'] = _MI_TC_BNAME1;
$modversion['blocks'][1]['description'] = "Builds the navigation";
$modversion['blocks'][1]['show_func'] = "tinycontent_block_nav";
$modversion['blocks'][1]['template'] = 'tc_nav_block.html';

// Comments
$modversion['hasComments'] = 1;
$modversion['comments']['itemName'] = 'id';
$modversion['comments']['pageName'] = 'index.php';

// Preferences
$modversion['config'][1]['name'] = 'tc_wysiwyg';
$modversion['config'][1]['title'] = '_MI_TC_WYSIWYG';
$modversion['config'][1]['description'] = '_MI_TC_WYSIWYG_DESC';
$modversion['config'][1]['formtype'] = 'yesno';
$modversion['config'][1]['valuetype'] = 'int';
$modversion['config'][1]['default'] = 0;

$modversion['config'][2]['name'] = 'tc_listing';
$modversion['config'][2]['title'] = '_MI_TC_LISTING';
$modversion['config'][2]['description'] = '_MI_TC_LISTING_DESC';
$modversion['config'][2]['formtype'] = 'yesno';
$modversion['config'][2]['valuetype'] = 'int';
$modversion['config'][2]['default'] = 0;
?>