/* Import plugin specific language pack */
tinyMCE.importPluginLanguagePack('insertdiv', 'fr,en,ja_euc-jp');
var valid_elements = new Array("div", "p", "span", "ul", "li", "font", "img", "html");

var TinyMCE_InsertDivPlugin = {
	
	getInfo : function() {
		return {
			longname : 'VDE - Visual Div Editor',
			author : 'Christophe Ebl - Newkind.',
			authorurl : 'http://www.newkind.biz',
			infourl : '',
			version : 'RC1.0'
		};
	},
	
	/**
	 * Returns the HTML contents of the insertdiv controls
	*/
	
	getControlHTML : function(cn) {
		switch (cn) {
			case "insertdiv":
				return tinyMCE.getButtonHTML(cn, 'lang_insertdiv', '{$pluginurl}/images/insertdiv.gif', 'mceInsertDiv');
		}

		return "";
	},
	
	execCommand : function(editor_id, element, command, user_interface, value) {
		/**
		Register DIV functions
		*/
		var divfunc = {			
			inArray : function(needle, haystack) {
				for (var i = 0; i < haystack.length; i++) {
					if (haystack[i] === needle) {
						return true;
					}
				}
				return false;
			},
			
			traverseDomForDiv : function(el) {
				var node = el;
				while (node) {
					  if (node.nodeType===1 && node.nodeName.toLowerCase() == "div") {
						 return node;
					  }
					  else {
						  node = node.parentNode;
					  }
				}
				return null;
			},
		
			getDomNode : function(el) {
				var node = el;
				 while (node) {
					  if (node.nodeType===1 && this.inArray(node.nodeName.toLowerCase(), valid_elements)) {
						 return node;
					  }
					  else {
						  node = node.parentNode;
					  }
				}
				return null;
			}
		};
		
		// Handle commands
		switch (command) {
			case "mceInsertDiv":
				var template = new Array();
				template['file']   = '../../plugins/insertdiv/idiv.htm'; // Relative to theme
				template['width']  = 550;
				template['height'] = 400;
				var selElem;
				// We must know if DIV is already wrapped into a DIV or not
				// And if the current node or its closest parent is allowed in valid_elements array
	
				selElemEdit = divfunc.traverseDomForDiv(tinyMCE.selectedElement);
				
				if(!selElemEdit)	{			
					if(divfunc.getDomNode(tinyMCE.selectedElement)) {
						// Element has been selected through tag selector
						selElem = divfunc.getDomNode(tinyMCE.selectedElement);
					}
				}
				else {
					selElem = selElemEdit;
				}
				
				if(selElem) {
					tinyMCE.openWindow(template, {editor_id : editor_id,  selElem : selElem, mceDo : 'update'});
					return true;
				}
	   }
	   // Pass to next handler in chain
	   return false;
	}
};

tinyMCE.addPlugin("insertdiv", TinyMCE_InsertDivPlugin);