function selectColor() {
	var color = document.getElementById("selectedColorBox").value;
	document.getElementById(""+field+"").value = color;
	document.getElementById(field+"-pick").style.backgroundColor = color;
	divclose();
}

function generateGrayScale() {
		var colors = new Array();
		for(var i = 0; i < 256; i++)
		{
			hex = decToHex(i);
			rgb = '#' + hex + hex + hex;
			colors.push(rgb);
		}
		return colors.reverse();
}


function showColor(color) {
	if(color.length == 7) {
		document.getElementById("selectedColor").style.backgroundColor = color;
		document.getElementById("selectedColorBox").value = color;
	}
}

function decToHex(dec) {
  var hexStr = "0123456789ABCDEF";
  var low = dec % 16;
  var high = (dec - low)/16;
  hex = "" + hexStr.charAt(high) + hexStr.charAt(low);
  return hex;
}

var field;

function pickColor(id, defcol) {
	var a_anchor = getAnchorPosition(id+"-anchor");	
	document.getElementById("colpick").style.top = (a_anchor.y + 10) + 'px';
	document.getElementById("colpick").style.left = (a_anchor.x) + 'px';
	document.getElementById("colpick").style.display = "inline";
	field = id;
}

function showDHTMLColorPicker(id, defcol) {
	var html = "";
	html += '<a name="'+id+'-anchor" id="'+id+'-anchor" href="javascript:void(0);" onkeydown="pickColor(\'' + id +'\', \'' + defcol + '\');" onmousedown="pickColor(\'' + id +'\', \'' + defcol + '\'); return false;">';
	html += '<img style="background-color:'+defcol+'" name="'+id+'-pick" id="'+id+'-pick" src="images/color.gif"';
	html += ' width="20" height="16" border="0"';
	html += ' /></a>';
	
	document.write(html);
}

function GradientPart(dr, dg, db, fr, fg, fb, Step) {             
    cr=dr;cg=dg;cb=db 
    //    Calcul du pas par couleur 
    sr=((fr-dr)/Step)    // rouge 
    sg=((fg-dg)/Step)    // vert 
    sb=((fb-db)/Step)    // bleu 
    var Result = '' 
    for (var x = 0; x < Step; x++) { 
        Result += '<td class="colcell" bgcolor="#'+ decToHex(Math.floor(cr)) + decToHex(Math.floor(cg)) + decToHex(Math.floor(cb)) +'" onclick="selectColor();" onfocus="showColor(\'#' + decToHex(Math.floor(cr)) + decToHex(Math.floor(cg)) + decToHex(Math.floor(cb))+'\');" onmouseover="showColor(\'#'+ decToHex(Math.floor(cr)) + decToHex(Math.floor(cg)) + decToHex(Math.floor(cb)) +'\');"></td>';
        cr += sr; cg += sg; cb += sb 
    }   
    return(Result) 
} 

function WriteRow(a,i){ 
    gradhtml+= "<tr>";
    gradhtml+= GradientPart(a,i,i, a,a,i, StepH);
    gradhtml+= GradientPart(a,a,i ,i,a,i, StepH);
    gradhtml+= GradientPart(i,a,i, i,a,a, StepH);
    gradhtml+= GradientPart(i,a,a, i,i,a, StepH);
    gradhtml+= GradientPart(i,i,a, a,i,a, StepH);
    gradhtml+= GradientPart(a,i,a, a,i,i, StepH);
    gradhtml+= "</tr>";
} 

function generatePalette(type) {

	var colWidth = 10;
	var colHeight = 10;
	// Height and Width of color squares on swatch
	
	var thtml = '<table cellpadding="0" cellspacing="1"><tr>';
	
	switch(type) {				
	// Color palette
	case "pas1":
		
		var colors = new Array("#FF4848","#FF68DD","#FF62B0","#FE67EB","#E469FE","#D568FD","#9669FE",
								"#FF7575","#FF79E1","#FF73B9","#FE67EB","#E77AFE","#D97BFD","#A27AFE",
								"#FF8A8A","#FF86E3","#FF86C2","#FE8BF0","#EA8DFE","#DD88FD","#AD8BFE",
								"#FF9797","#FF97E8","#FF97CB","#FE98F1","#ED9EFE","#E29BFD","#B89AFE",
								"#FFA8A8","#FFACEC","#FFA8D3","#FEA9F3","#EFA9FE","#E7A9FE","#C4ABFE",
								"#FFBBBB","#FFACEC","#FFBBDD","#FFBBF7","#F2BCFE","#EDBEFE","#D0BCFE",
								"#FFCECE","#FFC8F2","#FFC8E3","#FFCAF9","#F5CAFF","#F0CBFE","#DDCEFF",
								"#FFDFDF","#FFDFF8","#FFDFEF","#FFDBFB","#F9D9FF","#F4DCFE","#E6DBFF",
								"#FFECEC","#FFEEFB","#FFECF5","#FFEEFD","#FDF2FF","#FAECFF","#F1ECFF",
								"#FFF2F2","#FFFEFB","#FFF9FC","#FFF9FE","#FFFDFF","#FDF9FF","#FBF9FF",
								"#800080","#872187","#9A03FE","#892EE4","#3923D6","#2966B8","#23819C",
								"#BF00BF","#BC2EBC","#A827FE","#9B4EE9","#6755E3","#2F74D0","#2897B7",
								"#DB00DB","#D54FD5","#B445FE","#A55FEB","#8678E9","#4985D6","#2FAACE",
								"#F900F9","#DD75DD","#BD5CFE","#AE70ED","#9588EC","#6094DB","#44B4D5",
								"#FF4AFF","#DD75DD","#C269FE","#AE70ED","#A095EE","#7BA7E1","#57BCD9",
								"#FF86FF","#E697E6","#CD85FE","#C79BF2","#B0A7F1","#8EB4E6","#7BCAE1",
								"#FFA4FF","#EAA6EA","#D698FE","#CEA8F4","#BCB4F3","#A9C5EB","#8CD1E6",
								"#FFBBFF","#EEBBEE","#DFB0FF","#DBBFF7","#CBC5F5","#BAD0EF","#A5DBEB",
								"#FFCEFF","#F0C4F0","#E8C6FF","#E1CAF9","#D7D1F8","#CEDEF4","#B8E2EF",
								"#FFDFFF","#F4D2F4","#EFD7FF","#EDDFFB","#E3E0FA","#E0EAF8","#C9EAF3",
								"#FFECFF","#F4D2F4","#F9EEFF","#F5EEFD","#EFEDFC","#EAF1FB","#DBF0F7",
								"#FFF9FF","#FDF9FD","#FEFDFF","#FEFDFF","#F7F5FE","#F8FBFE","#EAF7FB");
			break;					
			
			case "pas2":					
			var colors = new Array("#5757FF","#62A9FF","#62D0FF","#06DCFB","#01FCEF","#03EBA6","#01F33E",
								"#6A6AFF","#75B4FF","#75D6FF","#24E0FB","#1FFEF3","#03F3AB","#0AFE47",
								"#7979FF","#86BCFF","#8ADCFF","#3DE4FC","#5FFEF7","#33FDC0","#4BFE78",
								"#8C8CFF","#99C7FF","#99E0FF","#63E9FC","#74FEF8","#62FDCE","#72FE95",
								"#9999FF","#99C7FF","#A8E4FF","#75ECFD","#92FEF9","#7DFDD7","#8BFEA8",
								"#AAAAFF","#A8CFFF","#BBEBFF","#8CEFFD","#A5FEFA","#8FFEDD","#A3FEBA",
								"#BBBBFF","#BBDAFF","#CEF0FF","#ACF3FD","#B5FFFC","#A5FEE3","#B5FFC8",
								"#CACAFF","#D0E6FF","#D9F3FF","#C0F7FE","#CEFFFD","#BEFEEB","#CAFFD8",
								"#E1E1FF","#DBEBFF","#ECFAFF","#C0F7FE","#E1FFFE","#BDFFEA","#EAFFEF",
								"#EEEEFF","#ECF4FF","#F9FDFF","#E6FCFF","#F2FFFE","#CFFEF0","#EAFFEF",
								"#F9F9FF","#F9FCFF","#FDFEFF","#F9FEFF","#FDFFFF","#F7FFFD","#F9FFFB",
								"#1FCB4A","#59955C","#48FB0D","#2DC800","#59DF00","#9D9D00","#B6BA18",
								"#27DE55","#6CA870","#79FC4E","#32DF00","#61F200","#C8C800","#CDD11B",
								"#4AE371","#80B584","#89FC63","#36F200","#66FF00","#DFDF00","#DFE32D",
								"#7CEB98","#93BF96","#99FD77","#52FF20","#95FF4F","#FFFFAA","#EDEF85",
								"#93EEAA","#A6CAA9","#AAFD8E","#6FFF44","#ABFF73","#FFFF84","#EEF093",
								"#A4F0B7","#B4D1B6","#BAFEA3","#8FFF6F","#C0FF97","#FFFF99","#F2F4B3",
								"#BDF4CB","#C9DECB","#CAFEB8","#A5FF8A","#D1FFB3","#FFFFB5","#F5F7C4",
								"#D6F8DE","#DBEADC","#DDFED1","#B3FF99","#DFFFCA","#FFFFC8","#F7F9D0",
								"#E3FBE9","#E9F1EA","#EAFEE2","#D2FFC4","#E8FFD9","#FFFFD7","#FAFBDF",
								"#E3FBE9","#F3F8F4","#F1FEED","#E7FFDF","#F2FFEA","#FFFFE3","#FCFCE9",
								"#FAFEFB","#FBFDFB","#FDFFFD","#F5FFF2","#FAFFF7","#FFFFFD","#FDFDF0");	
			break;
			
	case "col":
		var colors = new Array(
				"#000000","#7964AD","#000066","#000099","#0000CC","#0000FF","#330000","#330033","#330066","#330099","#3300CC",
				"#3300FF","#660000","#660033","#660066","#660099","#6600CC","#6600FF","#990000","#990033","#990066","#990099",
				"#9900CC","#9900FF","#CC0000","#CC0033","#CC0066","#CC0099","#CC00CC","#CC00FF","#FF0000","#FF0033","#FF0066",
				"#FF0099","#FF00CC","#FF00FF","#003300","#003333","#003366","#003399","#0033CC","#0033FF","#333300","#333333",
				"#333366","#333399","#3333CC","#3333FF","#663300","#663333","#663366","#663399","#6633CC","#6633FF","#993300",
				"#993333","#993366","#993399","#9933CC","#9933FF","#CC3300","#CC3333","#CC3366","#CC3399","#CC33CC","#CC33FF",
				"#FF3300","#FF3333","#FF3366","#FF3399","#FF33CC","#FF33FF","#006600","#006633","#006666","#006699","#0066CC",
				"#0066FF","#336600","#336633","#336666","#336699","#3366CC","#3366FF","#666600","#666633","#666666","#666699",
				"#6666CC","#6666FF","#996600","#996633","#996666","#996699","#9966CC","#9966FF","#CC6600","#CC6633","#CC6666",
				"#CC6699","#CC66CC","#CC66FF","#FF6600","#FF6633","#FF6666","#FF6699","#FF66CC","#FF66FF","#009900","#009933",
				"#009966","#009999","#0099CC","#0099FF","#339900","#339933","#339966","#339999","#3399CC","#3399FF","#669900",
				"#669933","#669966","#669999","#6699CC","#6699FF","#999900","#999933","#999966","#999999","#9999CC","#9999FF",
				"#CC9900","#CC9933","#CC9966","#CC9999","#CC99CC","#CC99FF","#FF9900","#FF9933","#FF9966","#FF9999","#FF99CC",
				"#FF99FF","#00CC00","#00CC33","#00CC66","#00CC99","#00CCCC","#00CCFF","#33CC00","#33CC33","#33CC66","#33CC99",
				"#33CCCC","#33CCFF","#66CC00","#66CC33","#66CC66","#66CC99","#66CCCC","#66CCFF","#99CC00","#99CC33","#99CC66",
				"#99CC99","#99CCCC","#99CCFF","#CCCC00","#CCCC33","#CCCC66","#CCCC99","#CCCCCC","#CCCCFF","#FFCC00","#FFCC33",
				"#FFCC66","#FFCC99","#FFCCCC","#FFCCFF","#00FF00","#00FF33","#00FF66","#00FF99","#00FFCC","#00FFFF","#33FF00",
				"#33FF33","#33FF66","#33FF99","#33FFCC","#33FFFF","#66FF00","#66FF33","#66FF66","#66FF99","#66FFCC","#66FFFF",
				"#99FF00","#99FF33","#99FF66","#99FF99","#99FFCC","#99FFFF","#CCFF00","#CCFF33","#CCFF66","#CCFF99","#CCFFCC",
				"#CCFFFF","#FFFF00","#FFFF33","#FFFF66","#FFFF99","#FFFFCC","#FFFFFF");
		break;
	// Greyscale palette
	case "grey":
		var colors = new Array();
			for(var i = 9; i < 256; i++)
			{
				hex = decToHex(i);
				rgb = '#' + hex + hex + hex;
				colors.push(rgb);
			}
			colors.reverse();
		break;
	
	case "gradient":
		//    ecriture du tableau de dgrad 
		gradhtml = '<table cellpadding="0" cellspacing="0"><tr>';
		StepH = 10; 
		var StepV = 8;
		var i=0 
		var a=0
	
		//    niveau fonc 
		for (a=0;a<=255; a+=StepV){ 
			 WriteRow(a,i); 
		} 
		a=255 
		//    niveau clair 
		for (i=0; i<=255; i+=StepV){ 
			 WriteRow(a,i); 
		}
		
		gradhtml += '</table>';
	
	break;
	
	} // End switch
	
	if(type != "gradient") { 
		for (var i=0; i <colors.length; i++) {
			thtml += '<td bgcolor="' + colors[i] + '">'
				+ '<a href="javascript:selectColor();" onfocus="showColor(\'' + colors[i] +  '\');" onmouseover="showColor(\'' + colors[i] +  '\');">'
				+ '<img border="0" src="images/spacer.gif" width="'+colWidth+'" height="'+colHeight+'" title="' + colors[i] +  '" alt="' + colors[i] +  '" /></a></td>';
			if ((i+1) % 18 == 0)
				thtml += '</tr><tr>';
		}
	}
	else {
		thtml += '<td>'+gradhtml+'</td></tr>';
	}
	thtml += '</table>';
	return thtml;
}

function convertRGBToHex(col) {
	var re = new RegExp("rgb\\s*\\(\\s*([0-9]+).*,\\s*([0-9]+).*,\\s*([0-9]+).*\\)", "gi");

	var rgb = col.replace(re, "$1,$2,$3").split(',');
	if (rgb.length == 3) {
		r = parseInt(rgb[0]).toString(16);
		g = parseInt(rgb[1]).toString(16);
		b = parseInt(rgb[2]).toString(16);

		r = r.length == 1 ? '0' + r : r;
		g = g.length == 1 ? '0' + g : g;
		b = b.length == 1 ? '0' + b : b;

		return "#" + r + g + b;
	}

	return col;
}

function divclose() {
	document.getElementById("colpick").style.display="none";
}

function convertHexToRGB(col) {
	if (col.indexOf('#') != -1) {
		col = col.replace(new RegExp('[^0-9A-F]', 'gi'), '');

		r = parseInt(col.substring(0, 2), 16);
		g = parseInt(col.substring(2, 4), 16);
		b = parseInt(col.substring(4, 6), 16);

		return "rgb(" + r + "," + g + "," + b + ")";
	}

	return col;
}

function renderColorMap(pal) {
	
	var html = "";
	var buttonLbl = tinyMCELang['lang_cancel'];
	
	//var inputColor = convertRGBToHex(tinyMCE.getWindowArg('input_color'));

	html += '<table border="0" cellspacing="1" cellpadding="0">'
		+ '<tr><td colspan="18">'
		+	'<div align="right"><label>Palette: <select name="colpalette" style="font-size:9px;" onchange="renderColorMap(this.options[this.selectedIndex].value);" id="colpalette"><option value="col">'+tinyMCELang['lang_insertdiv_select']+'</option><option value="col">'+tinyMCELang['lang_insertdiv_colpick_colorpal']+'</option><option value="grey">'+tinyMCELang['lang_insertdiv_colpick_greypal']+'</option><option value="pas1">'+tinyMCELang['lang_insertdiv_colpick_redtolightbluepal']+'</option><option value="pas2">'+tinyMCELang['lang_insertdiv_colpick_navybluetoyellowpal']+'</option><option value="gradient">'+tinyMCELang['lang_insertdiv_colpick_gradientpal']+'</option></select></label></div>'		
		+ 		'</td>'		
		+ '</tr>'
		+ '<tr>';
	html += '<td id="colpal_render">'+generatePalette(pal)+'</td>';
	html += '<tr><td colspan="18">'
		+ '<table width="100%" border="0" cellspacing="0" cellpadding="0">'
		+ '<tr><td id="selectedColor">'
		+ '<img border="0" src="images/spacer.gif" width="80" height="16" />'
		+ '</td><td align="right">'
		+ '<input id="selectedColorBox" name="selectedColorBox" type="text" size="7" maxlength="7" style="width:65px" />'
		+ '</td></tr>'
		+ '</table>'
		+ '<input type="button" id="undo" name="undo" value="'+buttonLbl+'" style="margin-top:3px" onclick="divclose();">'		
		+ '</td></tr>'
		+ '</table>';

	document.getElementById("colpick").innerHTML=html;
}