/* Import plugin specific language pack */
tinyMCE.importPluginLanguagePack('xquotecode', 'en,tr,de,sv,zh_cn,cs,fa,fr_ca,fr,pl,pt_br,nl,da,he,nb,hu,ru,ru_KOI8-R,ru_UTF-8,nn,fi,es,cy,is,zh_tw,zh_tw_utf8,sk,it');

// Plucin static class
var TinyMCE_XquotecodePlugin = {
	getInfo : function() {
		return {
			longname : 'XquoteCode',
			author : '',
			authorurl : '',
			infourl : '',
			version : tinyMCE.majorVersion + "." + tinyMCE.minorVersion
		};
	},

	/**
	 * Returns the HTML contents of the emotions control.
	 */
	getControlHTML : function(cn) {
		switch (cn) {
			case "xquote":
				return tinyMCE.getButtonHTML(cn, 'lang_insert_xquote_desc', '{$pluginurl}/images/xquote.gif', 'mceXquote');
			case "xcode":
				return tinyMCE.getButtonHTML(cn, 'lang_insert_xcode_desc', '{$pluginurl}/images/xcode.gif', 'mceXcode');
		}

		return "";
	},

	/**
	 * Executes the mceXquotecode command.
	 */
	execCommand : function(editor_id, element, command, user_interface, value) {
		// Handle commands
		switch (command) {
			case "mceXquote":
				var template = new Array();

				template['file'] = '../../plugins/xquotecode/xquote.htm'; // Relative to theme
				template['width'] = 400;
				template['height'] = 300;
				var qtext = "";
				tinyMCE.openWindow(template, {editor_id : editor_id, qtext : qtext, mceDo : 'insert'});

				return true;

			case "mceXcode":
				var template = new Array();

				template['file'] = '../../plugins/xquotecode/xcode.htm'; // Relative to theme
				template['width'] = 400;
				template['height'] = 300;
				var ctext = "";
				tinyMCE.openWindow(template, {editor_id : editor_id, ctext : ctext, mceDo : 'insert'});

				return true;
		}

		// Pass to next handler in chain
		return false;
	}
};

// Register plugin
tinyMCE.addPlugin('xquotecode', TinyMCE_XquotecodePlugin);


