<?php

function fsize($file)
{
    $size = 0;

    if(is_dir($file)) {
        if ($dh = opendir($file)) {
            while (($filecnt = readdir($dh)) !== false) {
                if($filecnt == '.' || $filecnt == '..') continue;
                if(is_dir($file.'/'.$filecnt)) {
                    $size += fsize($file.'/'.$filecnt);
                } else {
                    $size += filesize($file.'/'.$filecnt);
                }
            }
        } else {
            return false;
        }
    } else {
        $size = filesize($file);
    }    
    return $size;
}

function human_format_size( $bytes )
{
  $formats = array("%d Bytes", "%.1f KB", "%.1f MB", "%.1f GB", "%.1f TB");
  $logsize = min((int)(log($bytes)/log(1024)), count($formats)-1);
  return sprintf( $formats[$logsize], $bytes/pow(1024, $logsize));
}

function display_quota_bar($quota)
{
	$g=new HTMLGraph();
	$g->addSerie($quota,"#ffc21f","Mar");
	$g->isPercentage(true);
	//$g->setTitle("Your disk quota: ");
	$g->setWidth(250);
	$g->setBarHeight(14);
	$g->display();
}
?>