<?php
/*
* XRManager - Xoops Resources Manager
* built for TinyEditor by ralf57
* Version 1.0 - Genuary 2006
* Licensed under the terms of the GNU Lesser General Public License:
*/

	include "xrincludes.php";

	if (!defined('XOOPS_ROOT_PATH')) die("XOOPS root path not defined");

	$module_handler =& xoops_gethandler('module');
	$module =& $module_handler->getByDirname("tinyeditor");
	$config_handler =& xoops_gethandler('config');
	$moduleConfig =& $config_handler->getConfigsByCat(0, $module->getVar('mid'));
	$groups = (is_object($xoopsUser)) ? $xoopsUser->getGroups() : XOOPS_GROUP_ANONYMOUS;
	$module_id = $module->getVar('mid');
	$gperm_handler = &xoops_gethandler('groupperm');
	$groupid = array_shift($groups);

	if (is_object($xoopsUser))  { //only site users can access this file

		require_once XOOPS_ROOT_PATH.'/modules/tinyeditor/include/config.inc.php';
		require_once XOOPS_ROOT_PATH.'/modules/tinyeditor/class/XRManager.php';
		require_once XOOPS_ROOT_PATH.'/modules/tinyeditor/include/iconlookup.php';
		include XOOPS_ROOT_PATH.'/modules/tinyeditor/include/ctxmenu.php';
		include_once XOOPS_ROOT_PATH.'/modules/tinyeditor/include/functions.php';
include_once XOOPS_ROOT_PATH.'/modules/tinyeditor/class/mimelookup.php';
		//default path is /
		$relative = '/';
		$manager = new ResourceManager($IMConfig);

		//process any file actions
		$manager->processCopyFile(); // both copy and move cases
		$manager->processCopyFolder(); // both copy and move cases
		$manager->processUploads();
		$manager->renameFiles();
		$manager->renameFolders();
		$manager->deleteFiles();

		$refreshDir = false;

			//process any directory functions
			if( $manager->deleteDirs() || $manager->processNewDir()) $refreshDir = true;

			//check for any sub-directory request
			//check that the requested sub-directory exists
			//and valid
			if(isset($_REQUEST['dir'])) {
				$path = rawurldecode($_REQUEST['dir']);
    			if ($manager->validRelativePath($path)) $relative = $path;
			}

		//get the list of files and directories
		$list = $manager->getFiles($relative);

		$imagepath = $IMConfig['img_url'];

		/* ================= OUTPUT/DRAW FUNCTIONS ======================= */
		/**
		 * Draw the files in an table.
		 */
		//Added modifications for TinyMCE - Ryan Demmer
		function drawFiles($list, &$manager) {

        	global $relative, $imagepath, $xoopsUser, $i, $tiny_thumbcols, $menu_id, $xoopsDB, $groupid, $mimetype_array, $tiny_persdir, $tiny_mgruploads;
			$prepend = "";
include_once XOOPS_ROOT_PATH.'/modules/tinyeditor/include/tinyperm.php';
	$module_handler =& xoops_gethandler('module');
	$module =& $module_handler->getByDirname("tinyeditor");
	$groups = (is_object($xoopsUser)) ? $xoopsUser->getGroups() : XOOPS_GROUP_ANONYMOUS;
	$module_id = $module->getVar('mid');
	$gperm_handler = &xoops_gethandler('groupperm');

	$xuser_name = 'user_'.$xoopsUser->getVar('uid').'_';

			foreach($list as $entry => $file) {

		$serverpathtofile = str_replace(XOOPS_URL, XOOPS_ROOT_PATH, $imagepath.$file['relative']);
		$mimetype = new mimetype();
		$mimeread = $mimetype->getType($serverpathtofile);

// case 1: userdirs and no override
if ($tiny_persdir == 1 && preg_match("/".$xuser_name."/", $serverpathtofile) && !checkRightTiny('TinyPerm', 7, $groups, $module_id)) {
				if (in_array($mimeread, getMimeArray($groupid))) {
				
				if ($file['image']) {
					$itemtype = "image"; 
				} else { 
					$itemtype = "other";
				} //used in context menu

        		echo $prepend;
                echo "<td>\n";
				echo "<table width='120' cellpadding='0' cellspacing='0' border='0'>\n";
				echo "<tr>\n";
				echo "<td class='block'>\n";
                echo "<a href='javascript:;' onclick=\"insertFile('".$imagepath.$file['relative']."');\" title=\"".$entry." - ".Files::formatSize($file['stat']['size'])."\"><img src=\"".$manager->getThumbnail($file['relative'])."\" alt=\"".$entry." - ".Files::formatSize($file['stat']['size'])."\" /></a><br />\n";
				echo displayItemMenu($itemtype, $entry, $menu_id, $imagepath.$file['relative'], $relative, $file['relative'], '');
                echo "</td>\n";
				echo "</tr>\n";
				echo "</table>\n";
				echo "</td>\n";

				$i++; // incremental cells counter
				$menu_id++; // increment contextmenu id
				
					if (!($i % $tiny_thumbcols)) {
						$prepend = "</tr>\n<tr>\n";
					} else {
						$prepend = "";
					}
				}
        	}

// case 2: userdirs and override
if ($tiny_persdir == 1 && checkRightTiny('TinyPerm', 7, $groups, $module_id) == 1) {
				if (in_array($mimeread, getMimeArray($groupid))) {
				
				if ($file['image']) {
					$itemtype = "image"; 
				} else { 
					$itemtype = "other";
				} //used in context menu

        		echo $prepend;
                echo "<td>\n";
				echo "<table width='120' cellpadding='0' cellspacing='0' border='0'>\n";
				echo "<tr>\n";
				echo "<td class='block'>\n";
                echo "<a href='javascript:;' onclick=\"insertFile('".$imagepath.$file['relative']."');\" title=\"".$entry." - ".Files::formatSize($file['stat']['size'])."\"><img src=\"".$manager->getThumbnail($file['relative'])."\" alt=\"".$entry." - ".Files::formatSize($file['stat']['size'])."\" /></a><br />\n";
				echo displayItemMenu($itemtype, $entry, $menu_id, $imagepath.$file['relative'], $relative, $file['relative'], '');
                echo "</td>\n";
				echo "</tr>\n";
				echo "</table>\n";
				echo "</td>\n";

				$i++; // incremental cells counter
				$menu_id++; // increment contextmenu id
				
					if (!($i % $tiny_thumbcols)) {
						$prepend = "</tr>\n<tr>\n";
					} else {
						$prepend = "";
					}
				}
        	}

// case 3: no userdirs
if ($tiny_persdir == 0) {
				if (in_array($mimeread, getMimeArray($groupid))) {
				
				if ($file['image']) {
					$itemtype = "image"; 
				} else { 
					$itemtype = "other";
				} //used in context menu

        		echo $prepend;
                echo "<td>\n";
				echo "<table width='120' cellpadding='0' cellspacing='0' border='0'>\n";
				echo "<tr>\n";
				echo "<td class='block'>\n";
                echo "<a href='javascript:;' onclick=\"insertFile('".$imagepath.$file['relative']."');\" title=\"".$entry." - ".Files::formatSize($file['stat']['size'])."\"><img src=\"".$manager->getThumbnail($file['relative'])."\" alt=\"".$entry." - ".Files::formatSize($file['stat']['size'])."\" /></a><br />\n";
				echo displayItemMenu($itemtype, $entry, $menu_id, $imagepath.$file['relative'], $relative, $file['relative'], '');
                echo "</td>\n";
				echo "</tr>\n";
				echo "</table>\n";
				echo "</td>\n";

				$i++; // incremental cells counter
				$menu_id++; // increment contextmenu id
				
					if (!($i % $tiny_thumbcols)) {
						$prepend = "</tr>\n<tr>\n";
					} else {
						$prepend = "";
					}
				}
        	}

			} //foreach
		} //end function drawFiles

		/**
		 * Draw the directories in a table.
		 */
		function drawDirs($list, &$manager) {

			global $relative, $xoopsUser, $i, $tiny_thumbcols, $menu_id, $tiny_mgrdelnonempty, $tiny_persdir, $tiny_mgruploads;
			$prepend = "";
include_once XOOPS_ROOT_PATH.'/modules/tinyeditor/include/tinyperm.php';
	$module_handler =& xoops_gethandler('module');
	$module =& $module_handler->getByDirname("tinyeditor");
	$groups = (is_object($xoopsUser)) ? $xoopsUser->getGroups() : XOOPS_GROUP_ANONYMOUS;
	$module_id = $module->getVar('mid');
	$gperm_handler = &xoops_gethandler('groupperm');

if ($tiny_persdir == 1 && !is_dir(XOOPS_ROOT_PATH.$tiny_mgruploads.'/user_'.$xoopsUser->getVar('uid').'_')) {
	$xuser_name = 'user_'.$xoopsUser->getVar('uid').'_';
	mkdir (XOOPS_ROOT_PATH.$tiny_mgruploads.'/'.$xuser_name, 0777);
	chmod (XOOPS_ROOT_PATH.$tiny_mgruploads.'/'.$xuser_name, 0777);
} else {
	$xuser_name = 'user_'.$xoopsUser->getVar('uid').'_';
}

			foreach($list as $path => $dir) {
				// case 1: userdirs and no override
				if ($tiny_persdir == 1 && preg_match("/".$xuser_name."/", $path) && !checkRightTiny('TinyPerm', 7, $groups, $module_id)) {
				echo $prepend;

				$itemtype = "dir";
				$dir_del_alert = 0;
				
					if ($tiny_mgrdelnonempty == 0 && $dir['count'] > 0) $dir_del_alert = 1;
                
				echo "<td>\n";
				echo "<table width='120' cellpadding='0' cellspacing='0' border='0'>\n";
				echo "<tr>\n";
				echo "<td class='block'>\n";
               	echo "<a href=\"files.php?dir=".rawurlencode($path)."\" onclick=\"updateDir('".$path."', '"._TINYMGR_LOADING."')\" title=\"".$dir['entry']."\"><img src='images/folder.gif' height='48' width='48' alt=\"".$dir['entry']."\" /></a><br />\n";
				echo displayItemMenu($itemtype, $dir['entry'], $menu_id, $path, $relative, '', $dir_del_alert);
                echo "</td>\n";
				echo "</tr>\n";
				echo "</table>\n";
				echo "</td>\n";

				$i++; // increment cells counter
				$menu_id++; // increment contextmenu id
				if (!($i % $tiny_thumbcols)) {
					$prepend = "</tr>\n<tr>\n"; // draw new row
					echo $prepend; //fix a funny bug - now is ok
				} else {
					$prepend = ""; //add cell(s) in the old row
				}
        	}
        	
				// case 2: userdirs and override        	
				if ($tiny_persdir == 1 && checkRightTiny('TinyPerm', 7, $groups, $module_id) == 1) {
				echo $prepend;

				$itemtype = "dir";
				$dir_del_alert = 0;
				
					if ($tiny_mgrdelnonempty == 0 && $dir['count'] > 0) $dir_del_alert = 1;
                
				echo "<td>\n";
				echo "<table width='120' cellpadding='0' cellspacing='0' border='0'>\n";
				echo "<tr>\n";
				echo "<td class='block'>\n";
               	echo "<a href=\"files.php?dir=".rawurlencode($path)."\" onclick=\"updateDir('".$path."', '"._TINYMGR_LOADING."')\" title=\"".$dir['entry']."\"><img src='images/folder.gif' height='48' width='48' alt=\"".$dir['entry']."\" /></a><br />\n";
				echo displayItemMenu($itemtype, $dir['entry'], $menu_id, $path, $relative, '', $dir_del_alert);
                echo "</td>\n";
				echo "</tr>\n";
				echo "</table>\n";
				echo "</td>\n";

				$i++; // increment cells counter
				$menu_id++; // increment contextmenu id
				if (!($i % $tiny_thumbcols)) {
					$prepend = "</tr>\n<tr>\n"; // draw new row
					echo $prepend; //fix a funny bug - now is ok
				} else {
					$prepend = ""; //add cell(s) in the old row
				}
        	}        	

				// case 3: no userdirs        	
				if ($tiny_persdir == 0) {
				echo $prepend;

				$itemtype = "dir";
				$dir_del_alert = 0;
				
					if ($tiny_mgrdelnonempty == 0 && $dir['count'] > 0) $dir_del_alert = 1;
                
				echo "<td>\n";
				echo "<table width='120' cellpadding='0' cellspacing='0' border='0'>\n";
				echo "<tr>\n";
				echo "<td class='block'>\n";
               	echo "<a href=\"files.php?dir=".rawurlencode($path)."\" onclick=\"updateDir('".$path."', '"._TINYMGR_LOADING."')\" title=\"".$dir['entry']."\"><img src='images/folder.gif' height='48' width='48' alt=\"".$dir['entry']."\" /></a><br />\n";
				echo displayItemMenu($itemtype, $dir['entry'], $menu_id, $path, $relative, '', $dir_del_alert);
                echo "</td>\n";
				echo "</tr>\n";
				echo "</table>\n";
				echo "</td>\n";

				$i++; // increment cells counter
				$menu_id++; // increment contextmenu id
				if (!($i % $tiny_thumbcols)) {
					$prepend = "</tr>\n<tr>\n"; // draw new row
					echo $prepend; //fix a funny bug - now is ok
				} else {
					$prepend = ""; //add cell(s) in the old row
				}
        	}

			} // end foreach
		} // end function drawDirs

	/**
	* No directories and no files.
	*/
	function drawNoResults() {
		echo "<table width='100%'>\n";
		echo "<tr>\n";
		echo "<td class='noResult'>"._TINYMGR_EMPTYDIR."</td>\n";
		echo "</tr>\n";
		echo "</table>\n";
	}

	/**
	* No directories and no files.
	*/
	function drawErrorBase(&$manager) {
		echo "<table width='100%'>\n";
		echo "<tr>\n";
		echo "<td class='error'>"._TINYMGR_INVALIDBASEDIR."".$manager->config['base_dir']."</td>\n";
		echo "</tr>\n";
		echo "</table>\n";
	}

		echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">';
		echo "<html xmlns='http://www.w3.org/1999/xhtml' xml:lang='en' lang='en'>\n";
		echo "<head>\n";
		echo "<link href=\"css/fileslist.css\" rel=\"stylesheet\" type=\"text/css\" />\n";
		echo "<script type=\"text/javascript\" src=\"js/contextmenu.js\"></script>\n";
		echo "<script type=\"text/javascript\" src=\"js/ie5.js\"></script>\n";
		echo "<script type=\"text/javascript\" src=\"js/dialog.js\"></script>\n";
		echo "<script type=\"text/javascript\" src=\"js/imagePopup.js\"></script>\n";
		echo "<script type=\"text/javascript\">\n";
		echo "/*<![CDATA[*/\n";
        echo "if (window.top) I18N = window.top.I18N;\n";
		echo "function hideMessage() {\n";
		echo "var topDoc = window.top.document;\n";
		echo "var messages = topDoc.getElementById('messages');\n";
		echo "if (messages) messages.style.display = 'none';\n";
		echo "}\n";
		echo "init = function() {\n";
		echo "hideMessage();\n";
		echo "var topDoc = window.top.document;\n";

		//we need to refesh the drop directory list
		//save the current dir, delete all select options
		//add the new list, re-select the saved dir.
		if($refreshDir) {
			$dirs = $manager->getDirs();
			echo "var selection = topDoc.getElementById('dirPath');\n";
			echo "var currentDir = selection.options[selection.selectedIndex].text;\n";
			echo "while (selection.length > 0) { selection.remove(0); }\n";
			echo "selection.options[selection.length] = new Option('/',\"".rawurlencode('/')."\");\n";
				foreach($dirs as $relative=>$fullpath) {
					echo "selection.options[selection.length] = new Option(\"".$relative."\",\"".rawurlencode($relative)."\");\n";
				}
			echo "for (var i = 0; i < selection.length; i++) {\n";
			echo "var thisDir = selection.options[i].text;\n";
			echo "if (thisDir == currentDir) {\n";
			echo "selection.selectedIndex = i;\n";
			echo "break;\n";
			echo "}\n";
			echo "}\n";
		}

		echo "}\n";
		echo "function editImage(image) {\n";
		echo "var url = 'tools/editor.php?img='+image;\n";
		echo "Dialog(url, function(param) {\n";
		echo "if (!param) // user must have pressed Cancel\n";
		echo "return false;\n";
		echo "else {\n";
		echo "return true;\n";
		echo "}\n";
		echo "}, null);\n";
		echo "}\n";
		echo "/*]]>*/\n";
		echo "</script>\n";
		echo "<script type=\"text/javascript\" src=\"js/files.js\"></script>\n";
		echo "</head>\n";
		echo "<body>\n";
			if ($manager->isValidBase() == false) { drawErrorBase($manager); }
			elseif(count($list[0]) > 0 || count($list[1]) > 0) {
				echo "<table>\n";
				echo "<tr>\n";

				$menu_id = "1";
				$i = 0;  // cells counter.
				$cell_width = 1.65*$tiny_mgrthuwidth-10;

				drawDirs($list[0], $manager);
        		drawFiles($list[1], $manager);
				echo "</table>\n";
			} else { 
				drawNoResults();
			}
		echo "</body>\n";
		echo "</html>\n";
	} else {
		die(_NOPERM);
	}

?>