<?php
/*
* XRManager - Xoops Resources Manager
* built for TinyEditor by ralf57
* Version 1.0 - Genuary 2006
* based on Wei Zhuo's Image Manager
* Licensed under the terms of the GNU Lesser General Public License:
* http://www.opensource.org/licenses/lgpl-license.php
*/

	include 'xrincludes.php';

	if (is_object($xoopsUser)) { //only site users can access this file

		require_once XOOPS_ROOT_PATH.'/modules/tinyeditor/include/config.inc.php';
		require_once XOOPS_ROOT_PATH.'/modules/tinyeditor/include/helpers.php';
		require_once XOOPS_ROOT_PATH.'/modules/tinyeditor/class/XRManager.php';
		include_once XOOPS_ROOT_PATH.'/modules/tinyeditor/class/HTMLGraph.php';
		include_once XOOPS_ROOT_PATH.'/modules/tinyeditor/include/tinyperm.php';
		
		$manager = new ResourceManager($IMConfig);
		$dirs = $manager->getDirs();

		$max_width = $IMConfig['thumbnail_width'];
		$max_height = $IMConfig['thumbnail_height'];

		echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">';
		echo "<html xmlns='http://www.w3.org/1999/xhtml' xml:lang='en' lang='en'>";
		echo "<head>";
		echo "<title>"._TINYMGR_7."</title>";
		echo "<link type='text/css' rel='stylesheet' href='css/manager.css' />";
		echo "<script type='text/javascript' src='js/manager.js'></script>";
		echo "<script type='text/javascript' src='js/popup.js'></script>";
		echo "<script type='text/javascript' src='js/dialog.js'></script>";
		echo "<script type='text/javascript'>\n";
		echo "/*<![CDATA[*/\n";
        echo "var thumbdir = '".$IMConfig['thumbnail_dir']."';\n";
        echo "var base_url = '".$manager->getBaseURL()."';\n";
		echo "/*]]>*/\n";
		echo "</script>\n";
		echo "</head>";
		echo "<body onload='init();'>";
		echo "<form action='files.php' id='uploadForm' method='post' enctype='multipart/form-data'>";
		echo "<div id='page'>";
		echo "<div id='top_panel'>";
		echo "<div class='pres'>";
		echo $xoopsConfig['sitename']."<br />";
		echo _TINYMGR_8;
		echo "</div>";
		echo "<div class='top_nav'>";
		
		echo "<div class='dirs'>";
		echo "<label for='dirPath'>"._TINYMGR_11."</label>";
		echo "<select name='dir' class='dirWidth' id='dirPath' onchange=\"updateDir(this, '"._TINYMGR_LOADING."')\">";
		if ($tiny_persdir == 0 || checkRightTiny('TinyPerm', 7, $groups, $module_id) == 1)if ($tiny_persdir == 0 || checkRightTiny('TinyPerm', 7, $groups, $module_id) == 1) echo "<option value='/'>/</option>";
			foreach($dirs as $relative=>$fullpath) {
				echo "<option value='".$relative."'>".$relative."</option>";
			}
		echo "</select>";
		echo "<a href='#' onclick=\"javascript: goUpDir('"._TINYMGR_LOADING."');\"><img src='images/dir_up.png' alt='"._TINYMGR_9."' title='"._TINYMGR_9."' class='sixteenicon' /></a>";
			if ($gperm_handler->checkRight('TinyPerm', 4, $groups, $module_id)) {
				echo "<a href='#' onclick='newFolder();'><img src='images/dir_new.png' alt='"._TINYMGR_10."' title='"._TINYMGR_10."' class='sixteenicon' /></a>";
			}
		echo "<div id='messages' style='display: none;'><span id='message'></span><img src='images/dots.gif' width='22' height='12' alt='...' /></div>";
		echo "</div>";
		echo "</div>";
		echo "<div class='clearboth'></div>";
		echo "</div>";
		echo "<div id='main_panel'>";
		echo "<iframe src='files.php' name='imgManager' id='imgManager' class='imageFrame' scrolling='auto' frameborder='0'></iframe>";
			if ($gperm_handler->checkRight('TinyPerm', 1, $groups, $module_id)) {
				echo "<br /><br />";
				echo "<fieldset class='uploadArea'>";
				echo "<legend><b>"._TINYMGR_UPLOADS."</b></legend>";
				echo "<label for='upload'>"._TINYMGR_UPNEWFILE."</label>";
				echo "<input type='file' name='upload' id='upload' size='28' />&nbsp;<input type='submit' name='submit' value='"._TINYMGR_SUBMITFILE."' onclick=\"doUpload('"._TINYMGR_UPLOADING."');\" class='formButton' />";
				echo "</fieldset>";
			}
		
		echo "<br />";
		echo "</div>";
		echo "</div>";
		echo "</form>";
		echo "</body>";
		echo "</html>";
	} else {
		die(_NOPERM);
	}

?>