<?php
// $Id: editorFrame.php,v 1.5 2006/06/28 10:39:31 frankblacksf Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Author: Kazumi Ono (AKA onokazu)                                          //
// URL: http://www.myweb.ne.jp/, http://www.xoops.org/, http://jp.xoops.org/ //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //

	include "../xrincludes.php";

	//only site users can access this file 
	if (is_object($xoopsUser)) {

		require_once('../../include/config.inc.php');
		require_once('../../class/XRManager.php');
		require_once('../../class/ImageEditor.php');

		$manager = new ResourceManager($IMConfig);
		$editor = new ImageEditor($manager);
		$imageInfo = $editor->processImage();

		echo "<html>";
		echo "<head>";
		echo "<title>"._TINYMGR_EDITOR."</title>";
		echo "<link href=\"../css/editorFrame.css\" rel=\"stylesheet\" type=\"text/css\" />";
		echo "<script type=\"text/javascript\" src=\"../js/wz_jsgraphics.js\"></script>";
		echo "<script type=\"text/javascript\" src=\"../js/EditorContent.js\"></script>";
		echo "<script type=\"text/javascript\">\n";
		echo "if(window.top)\n";
		echo "I18N = window.top.I18N;\n";
		echo "function i18n(str) {\n";
		echo "if(I18N)\n";
		echo "return (I18N[str] || str);\n";
		echo "else\n";
		echo "return str;\n";
		echo "};\n";

		echo "var mode = \"".$editor->getAction()."\"\n"; //crop, scale, measure
			if (count($imageInfo)>0) $rawurlimageInfo =  rawurlencode($imageInfo['file']);
		echo "var currentImageFile = \"".$rawurlimageInfo."\";\n";

			if ($editor->isFileSaved() == 1) {
				echo "alert(i18n('File saved.'));\n";
			} elseif ($editor->isFileSaved() == -1) {
				echo "alert(i18n('File was not saved.'));\n";
			}

		echo "</script>";
		echo "<script type='text/javascript' src='../js/editorFrame.js'></script>";
		echo "</head>";
		echo "<body>";
		echo "<div id=\"status\"></div>";
		echo "<div id=\"ant\" class=\"selection\" style=\"visibility: hidden;\"><img src=\"../images/editor/spacer.gif\" width=\"0\" height=\"0\" border=\"0\" alt=\"\" id=\"cropContent\" /></div>";
			if ($editor->isGDEditable() == -1) { 
				echo "<div style='text-align:center; padding:10px;'><span class='error'>"._TINYMGR_NOGIFSUPP."</span></div>";
			}
		echo "<table height='100%' width='100%'>";
		echo "<tr>";
		echo "<td>";
			if (count($imageInfo) > 0 && is_file($imageInfo['fullpath'])) {
				echo "<span id='imgCanvas' class='crop'><img src='".$imageInfo['src']."' ".$imageInfo['dimensions']." alt='' id='theImage' name='theImage' /></span>";
			} else {
				echo "<span class='error'>"._TINYMGR_NOIMG."</span>";
			}
		echo "</td>";
		echo "</tr>";
		echo "</table>";
		echo "</body>";
		echo "</html>";
	} else {
		die(_NOPERM);
	}

?>